package com.elitescloud.cloudt.system.model.vo.resp.org;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionQueryVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 员工组织.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工组织")
public class EmpOrgRespVO implements Serializable {
    private static final long serialVersionUID = -2127253519141495718L;

    /**
     * 组织
     */
    @ApiModelProperty(value = "组织", position = 1)
    private List<IdCodeNameParam> details;

    /**
     * 领导用户ID
     */
    @ApiModelProperty(value = "领导用户ID", position = 2)
    private Long leaderUserId;

    /**
     * 领导用户ID
     */
    @ApiModelProperty(value = "领导用户姓名", position = 3)
    private String leaderUserName;

    @ApiModelProperty(value = "是否默认组织", position = 4)
    private Boolean def;

    @ApiModelProperty(value = "是否负责人", position = 5)
    private Boolean assignee;

    @ApiModelProperty(value = "岗位", position = 6)
    private SysPositionVo positionVo;

    public Long getOrgId() {
        if (details == null || details.isEmpty()) {
            return null;
        }

        return details.get(details.size() - 1).getId();
    }
    public String getSimple() {
        if (details == null || details.isEmpty()) {
            return "";
        }
        return details.get(details.size() - 1).getName();
    }
    public String getFull() {
        if (details == null || details.isEmpty()) {
            return "";
        }

        return details.stream()
                .map(IdCodeNameParam::getName)
                .collect(Collectors.joining("/"));
    }
}
