package com.elitescloud.cloudt.system.model.vo.resp.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/15
 */
@Getter
@Setter
@ApiModel(description = "角色组和角色信息")
public class GroupRoleRespVO implements Serializable {
    private static final long serialVersionUID = -2736974487329867424L;

    @ApiModelProperty(value = "分组ID", position = 1)
    private Long groupId;

    @ApiModelProperty(value = "分组编码", position = 2)
    private String groupCode;

    @ApiModelProperty(value = "分组名称", position = 3)
    private String groupName;

    @ApiModelProperty(value = "角色列表", position = 4)
    private List<Role> roles;

    @Getter
    @Setter
    @ApiModel(description = "角色组下的角色信息")
    public static class Role implements Serializable {
        private static final long serialVersionUID = 8162551213106710418L;

        @ApiModelProperty(value = "角色ID", position = 1)
        private Long roleId;

        @ApiModelProperty(value = "角色编码", position = 2)
        private String roleCode;

        @ApiModelProperty(value = "角色名称", position = 3)
        private String roleName;
    }
}
