package com.elitescloud.cloudt.system.model.vo.resp.sys;

import cn.hutool.core.text.CharSequenceUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 子账号列表信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/28
 */
@Getter
@Setter
@ApiModel(description = "子账号列表信息")
public class SubUserListRespVO implements Serializable {
    private static final long serialVersionUID = -4865893182994741199L;

    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "子账号ID", position = 2)
    private Long subUserId;

    @ApiModelProperty(value = "加入时间", position = 3)
    private LocalDateTime createTime;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 11)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 12)
    private String fullName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String lastName;
    @ApiModelProperty(hidden = true)
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String firstName;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 14)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 15)
    private String email;

    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }
}
