package com.elitescloud.cloudt.system.model.vo.save.businessobject;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 业务对象保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/20
 */
@Getter
@Setter
@ApiModel(description = "业务对象保存信息")
public class BusinessObjectSaveVO implements Serializable {
    private static final long serialVersionUID = -4559550802550113955L;

    @NotNull(message = "业务对象ID为空")
    @ApiModelProperty(value = "业务对象ID", required = true, position = 1)
    private Long id;

    @ApiModelProperty(value = "业务对象名称", required = true, position = 2)
    private String name;
}
