package com.elitescloud.cloudt.system.model.vo.save.devops;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 导出基础数据信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/27
 */
@Data
@ApiModel(description = "导出基础数据信息")
public class ExportBasicDataSaveVO implements Serializable {
    private static final long serialVersionUID = 8765870831377150797L;

    @ApiModelProperty(value = "是否全量导出", position = 1, hidden = true)
    private Boolean allVersion;

    @ApiModelProperty(value = "数据版本", position = 2, hidden = true)
    private String dataVersion;

    @ApiModelProperty(value = "是否全部类型", position = 3)
    private Boolean allType;

    @ApiModelProperty(value = "数据类型", position = 4)
    private Set<String> dataTypes;

    @ApiModelProperty(value = "导出应用", position = 5)
    private Set<String> appCodes;

    @ApiModelProperty(value = "租户编码", position = 6, hidden = true)
    private String tenantCode;

    @ApiModelProperty(value = "导出说明", position = 11)
    private String description;
}
