package com.elitescloud.cloudt.system.model.vo.save.dpr;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 数据权限字段保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/16
 */
@Getter
@Setter
@ApiModel(description = "数据权限字段保存信息")
public class DataPermissionFieldSaveVO implements Serializable {
    private static final long serialVersionUID = -6748176755512390841L;

    @ApiModelProperty(value = "字段名称", position = 1, required = true)
    @NotBlank(message = "字段名称不能为空")
    private String fieldName;

    @ApiModelProperty(value = "可读", position = 3)
    private Boolean readable;

    @ApiModelProperty(value = "可写", position = 4)
    private Boolean writeable;
}
