package com.elitescloud.cloudt.system.model.vo.save.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 员工组保存信息.
 *
 * @author Kaiser（wang shao）
 * 2023/1/16
 */
@Data
@ApiModel(description = "员工组保存信息")
public class EmpGroupSaveVO implements Serializable {
    private static final long serialVersionUID = -6256120753057026318L;

    /**
     * 员工组ID，编辑时必填
     */
    @ApiModelProperty(value = "员工组ID，编辑时必填", position = 1)
    private Long id;

    /**
     * 员工组编码
     */
    @ApiModelProperty(value = "员工组编码", position = 2, required = true)
    @NotBlank(message = "员工组编码为空")
    private String code;

    /**
     * 员工组名称
     */
    @ApiModelProperty(value = "员工组名称", position = 3, required = true)
    @NotBlank(message = "员工组名称为空")
    private String name;

    /**
     * 类型，[UDC]cloudt-empGroupType
     */
    @ApiModelProperty(value = "类型，[UDC]cloudt-system:empGroupType", position = 4)
    private String type;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 5)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;
}
