package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * 角色关联的权限信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/17
 */
@Data
@ApiModel(description = "角色关联的权限信息")
public class RoleAppPermissionBatchSaveVO implements Serializable {
    private static final long serialVersionUID = 801497286598895434L;

    @ApiModelProperty(value = "应用编码", position = 1, required = true)
    @NotBlank(message = "应用编码为空")
    private String appCode;

    @ApiModelProperty(value = "角色ID列表", position = 2, required = true)
    @NotEmpty(message = "角色ID列表为空")
    private List<Long> roleIds;

    @ApiModelProperty(value = "是否新增", position = 3, required = true)
    private Boolean add;

    @ApiModelProperty(value = "权限列表", position = 2)
    @Valid
    private List<RolePermissionSaveVO> permissionList;
}
