package com.elitescloud.cloudt.system.model.vo.save.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 认证用户表单.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/10
 */
@Getter
@Setter
@ApiModel(description = "认证用户表单")
public class AuthUserFormVO implements Serializable {
    private static final long serialVersionUID = -2960849521744027739L;

    /**
     * {@link com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter.IdType}
     */
    @ApiModelProperty(value = "账号类型")
    private String idType;

    @ApiModelProperty(value = "账号标识", required = true)
    private String id;

    /**
     * {@link com.elitescloud.cloudt.system.common.IdEncodedTypeEnum}
     */
    @ApiModelProperty(value = "加密类型")
    private String cipherType;
}
