package com.elitescloud.cloudt.system.model.vo.save.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 密码安全策略.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/8
 */
@Data
@ApiModel(description = "密码安全策略")
public class PwdStrategySaveVO implements Serializable {
    private static final long serialVersionUID = 4580344594531159507L;

    @ApiModelProperty(value = "策略编码", position = 1)
    @NotBlank(message = "策略编码为空")
    private String strategyCode;

    @ApiModelProperty(value = "策略参数", position = 2)
    private String[] params;
}
