package com.elitescloud.cloudt.system.model.vo.save.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;
import java.util.Set;

/**
 * 子账号保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/27
 */
@Getter
@Setter
@ApiModel(description = "子账号批量保存信息")
public class SubUserBatchSaveVO extends SubUserBaseSaveVO {
    private static final long serialVersionUID = 7484868716818933394L;

    @NotEmpty(message = "账号信息为空")
    @ApiModelProperty(value = "账号信息", position = 11, required = true)
    private Set<Long> userIds;
}
