package com.elitescloud.cloudt.system.model.vo.save.user.sync;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * JDE账号信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Getter
@Setter
@ApiModel(description = "JDE账号信息")
public class JdeUserSaveVO implements Serializable {
    private static final long serialVersionUID = -7679245419573952195L;

    @ApiModelProperty(value = "账户ID", position = 1, required = true)
    @NotNull(message = "账户ID为空")
    private Long id;

    @ApiModelProperty(value = "JDE账户", position = 11, required = true)
    @NotBlank(message = "JDE账户为空")
    private String jdeAccount;

    @ApiModelProperty(value = "JDE语言", position = 12)
    private String jdeLang;

    @ApiModelProperty(value = "JDE时区", position = 12)
    private String jdeTimeZone;
}
