package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:23
 */
@Service
@Slf4j
public class DprSysInternallyEmployeeLocalSub implements DprValueResolverSPI {

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[] {SysDprValueType.DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();
        if (userInfo.getUser().getEmployeeId() != null){
            List<Long> employeeIdList = new ArrayList<>(16);
            employeeIdList.add(userInfo.getUser().getEmployeeId());

            // 下属
            if (CollUtil.isNotEmpty(userInfo.getUser().getUnderlingList())) {
                var underlingIdList = userInfo.getUser().getUnderlingList().stream().map(SysUnderlingDTO::getEmployeeId).collect(Collectors.toList());
                employeeIdList.addAll(underlingIdList);
            }
            dprRuleValueSysInternallyBo.setValue(employeeIdList);
        }else{
            log.error("数据权限错误：账号没有员工信息D");
            dprRuleValueSysInternallyBo.setValue(null);
        }

        return dprRuleValueSysInternallyBo;
    }
}
