package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description : 本人-员工业务员
 * @date : 2023-12-22 13:24
 */
@Service
@Slf4j
public class DprSysInternallyEmployeeSalesman implements DprValueResolverSPI {

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();

        var userTypeList = userInfo.getUser().getUserTypeList();
        List<String> salesmanIdList = null;
        if (CollUtil.isNotEmpty(userTypeList)) {
            salesmanIdList = userTypeList.stream().filter(t -> UserType.SALESMAN.getValue().equals(t.getUserType()))
                    .map(SysUserType::getIdentityId)
                    .filter(StringUtils::hasText)
                    .collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(salesmanIdList)) {
            log.warn("未查询到员工的业务员ID：{}", userInfo.getUserId());
        }
        dprRuleValueSysInternallyBo.setValue(salesmanIdList);

        return dprRuleValueSysInternallyBo;
    }
}
