package com.elitescloud.cloudt.system.modules.message.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/23 10:07
 */
@Entity
@Table(name = "sys_msg_send_record", indexes = {
        @Index(name = "index_msgType", columnList = "msgType"),
        @Index(name = "index_sendUserId", columnList = "sendUserId"),
        @Index(name = "index_sendTime", columnList = "sendTime"),
        @Index(name = "index_batchUuid", columnList = "batchUuid"),
        @Index(name = "index_recipientUserName", columnList = "recipientUserName"),
        @Index(name = "index_recipientUserId", columnList = "recipientUserId")
})
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
@Comment("消息发送记录")
public class SysMsgSendRecordDO extends BaseModel {
    private static final long serialVersionUID = 8760955879353063100L;

    /**
     * @see MsgTypeEnum
     */
    @Comment("消息类型-枚举（模板、自定义）")
    @Column(length = 40)
    private String msgType;

    @Comment("发送人id")
    @Column(length = 40)
    private String sendUserId;

    @Comment("发送人名称")
    @Column(length = 40)
    private String sendUserName;

    @Comment("接收人名称")
    @Column(length = 40)
    private String recipientUserName;

    @Comment("接收人id")
    @Column(length = 40)
    private String recipientUserId;

    @Comment("发送人编码")
    @Column(length = 40)
    private String sendUserCode;

    @Comment("发送人编码")
    @Column(length = 40)
    private String recipientUserCode;

    @Comment("发送时间")
    @Column()
    private LocalDateTime sendTime;

    @Comment("批量号")
    @Column()
    private String batchUuid;

    @Comment("模板编码")
    @Column()
    private String templateCode;

    @Comment("模板名称")
    @Column()
    private String templateName;

    @Comment("自定义参数json")
    @Column()
    @Lob
    private String customParamJson;

    @Comment("发送参数json")
    @Column()
    @Lob
    private String sendParamJson;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysMsgSendRecordDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysMsgSendRecordDO entity = (SysMsgSendRecordDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}