package com.elitescloud.cloudt.system.modules.orgtree.common;

import com.elitescloud.boot.common.BaseUdc;

import javax.validation.constraints.NotBlank;

/**
 * 组织树状态.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/6
 */
public class OrgBuTreeStatus extends BaseUdc<OrgBuTreeStatus> {
    private static final long serialVersionUID = -9138052052207786984L;

    public static final String UDC_CODE = "BUTREE_STATUS";

    public static final OrgBuTreeStatus DRAFT = new OrgBuTreeStatus("DRAFT", "草稿");
    public static final OrgBuTreeStatus ACTIVE = new OrgBuTreeStatus("ACTIVE", "正常");
    public static final OrgBuTreeStatus CLOSED = new OrgBuTreeStatus("CLOSED", "已停用");

    public OrgBuTreeStatus() {
    }

    public OrgBuTreeStatus(String value) {
        super(value);
    }

    public OrgBuTreeStatus(String value, String description) {
        super(value, description);
    }

    @Override
    public @NotBlank String getUdcCode() {
        return UDC_CODE;
    }
}
