package com.elitescloud.cloudt.system.modules.orgtree.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Entity(name = "OrgBuTreeDO_system")
@Table(name = "sys_org_bu_tree")
@org.hibernate.annotations.Table(appliesTo = "sys_org_bu_tree", comment = "组织树")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "组织树", description = "组织树")
public class OrgBuTreeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 组织树类型
     */
    @ApiModelProperty(value = "组织树类型")
    @Column(name = "bu_tree_type")
    private String buTreeType;

    /**
     * 组织树类型2
     */
    @ApiModelProperty(value = "组织树类型2")
    @Column(name = "bu_tree_type2")
    private String buTreeType2;

    /**
     * 组织树类型3
     */
    @ApiModelProperty(value = "组织树类型3")
    @Column(name = "bu_tree_type3")
    private String buTreeType3;

    /**
     * 组织树状态
     */
    @ApiModelProperty(value = "组织树状态")
    @Column(name = "bu_tree_status")
    private String buTreeStatus;

    /**
     * 组织树编号
     */
    @ApiModelProperty(value = "组织树编号")
    @Column(name = "bu_tree_code")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty(value = "组织树名称")
    @Column(name = "bu_tree_name")
    private String buTreeName;

    /**
     * 组织树版本
     */
    @ApiModelProperty(value = "组织树版本")
    @Column(name = "bu_tree_version")
    private String buTreeVersion;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty(value = "组织树当前版本")
    @Column(name = "now_version")
    private String nowVersion;

    /**
     * 类别码
     */
    @ApiModelProperty(value = "类别码")
    @Column(name = "cat")
    private String cat;

    /**
     * 类别码2
     */
    @ApiModelProperty(value = "类别码2")
    @Column(name = "cat2")
    private String cat2;

    /**
     * 类别码3
     */
    @ApiModelProperty(value = "类别码3")
    @Column(name = "cat3")
    private String cat3;

    /**
     * 类别码4
     */
    @ApiModelProperty(value = "类别码4")
    @Column(name = "cat4")
    private String cat4;

    /**
     * 类别码5
     */
    @ApiModelProperty(value = "类别码5")
    @Column(name = "cat5")
    private String cat5;

    /**
     * 类别码6
     */
    @ApiModelProperty(value = "类别码6")
    @Column(name = "cat6")
    private String cat6;

    /**
     * 类别码
     */
    @ApiModelProperty(value = "类别码")
    @Column(name = "cat7")
    private String cat7;

    /**
     * 类别码8
     */
    @ApiModelProperty(value = "类别码8")
    @Column(name = "cat8")
    private String cat8;

    /**
     * 类别码9
     */
    @ApiModelProperty(value = "类别码9")
    @Column(name = "cat9")
    private String cat9;

    /**
     * 类别码10
     */
    @ApiModelProperty(value = "类别码10")
    @Column(name = "cat10")
    private String cat10;

    /**
     * 发布时间
     */
    @ApiModelProperty(value = "发布时间")
    @Column
    @Comment("发布时间")
    private LocalDateTime releaseTime;

    /**
     * 是否当前版本
     */
    @ApiModelProperty(value = "是否当前版本")
    @Column
    @Comment("是否当前版本")
    private Boolean isNowVersion;

    /**
     * 停用时间
     */
    @ApiModelProperty(value = "停用时间")
    @Column
    @Comment("停用时间")
    private LocalDateTime disableTime;

    /**
     * 发布人
     */
    @ApiModelProperty(value = "发布人")
    @Column
    @Comment("发布人")
    private String releaseUser;

    /**
     * 版本说明
     */
    @ApiModelProperty(value = "版本说明")
    @Column
    @Comment("版本说明")
    private String versionInstruction;
}
