package com.elitescloud.cloudt.system.modules.orgtree.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author nc
 * @date 2024/5/2
 */
@Entity
@Table(name = "sys_orgbu_tree_employee")
@org.hibernate.annotations.Table(appliesTo = "sys_orgbu_tree_employee", comment = "组织树员工关系")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "组织树员工关系", description = "组织树员工关系")
public class OrgBuTreeEmployeeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 组织树ID
     */
    @ApiModelProperty(value = "组织树ID")
    @Column(name = "bu_tree_id")
    private Long buTreeId;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID")
    @Column(name = "bu_id")
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    @Column(length = 40)
    private String buCode;

    @ApiModelProperty(value = "员工id")
    @Column()
    private Long employeeId;
    @Column()
    @Comment("员工所在组织的岗位ID")
    private Long positionId;

    @Column()
    @Comment("领导用户ID")
    private Long leaderUserId;

    @Column()
    @Comment("领导的员工ID")
    private Long leaderEmployeeId;


}
