package com.elitescloud.cloudt.system.modules.orgtree.model.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/1/1117:59
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OrgBuTreeVListParam implements Serializable {
    private static final long serialVersionUID = -8040833284368544628L;

    @ApiModelProperty("组织树id")
    private Long id;

    // 组织树编码
    @ApiModelProperty("组织树编码")
    private String buTreeCode;

    /**
     * 组织树版本
     */
    @ApiModelProperty("组织树版本")
    private String version;

    /**
     * 是否查看履历数据
     */
    @ApiModelProperty("是否查看履历数据（true:仅能看到“正常”+“已停用”状态的组织树;  false/null:所有状态的组织树 ）")
    private Boolean whetherViewResumeData;



}
