package com.elitescloud.cloudt.system.modules.orgtree.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.ucenter.utils.TreeNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/16
 */
@Data
@ApiModel(description = "组织树明细反参")
public class OrgBuTreeDVO implements TreeNode<OrgBuTreeDVO> {

    private static final long serialVersionUID = -7758785026638570573L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树节点ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树ID")
    private Long buTreeId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "BU组织ID")
    private Long buId;

    /**
     * BU组织编号
     */
    @ApiModelProperty(value = "BU组织编号")
    private String buCode;

    /**
     * BU组织名称
     */
    @ApiModelProperty(value = "BU组织名称")
    private String buName;

    /**
     * BU组织简称
     */
    @ApiModelProperty(value = "BU组织简称")
    private String buAbbr;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty(value = "组织类型 [UDC]ORG:BU_TYPE")
//    @SysCode(sys = "yst-supp", mod = "BU_TYPE")
    private String buType;
    private String buTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty(value = "组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "yst-supp", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 商品品类下级
     */
    @ApiModelProperty(value = "商品品类下级")
    private List<OrgBuTreeDVO> treeNodes;
}
