package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreePagingDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
public interface OrgBuTreeDomainService {

    /**
     * 组织树新增、更新
     *
     * @param param
     * @return
     */
    Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param);

    /**
     * 通过id获取组织树详细信息，包含树状结构
     *
     * @param id
     * @return
     */
    OrgBuTreeDetailDTO getOrgBuTreeDetailById(Long id);

    /**
     * 组织树分页条件查询
     *
     * @param param
     * @return
     */
    PagingVO<OrgBuTreePagingDTO> queryOrgBuTreeByParams(OrgBuTreePagingParam param);

    /**
     * 组织树确认、停用
     *
     * @param param
     */
    void updateStatus(OrgBuTreeStatusParam param);


    /**
     * 根据param 获取组织树信息
     *
     * @param param param
     * @return list
     */
    List<OrgBuTreeDTO> findOrgBuTreeDTOByParam(OrgBuTreeParam param);

    /**
     * 根据param获取组织树履历数据
     * @param param param
     * @return 分页数据
     */
    PagingVO<OrgBuTreeDTO> getBuTreePagingByParam(OrgBuTreeVPagingParam param);


    /**
     * 根据组织树编码获取是否可以创建新版本组织树标识
     *
     * @param buTreeCode
     * @return
     */
    Boolean getCreateNewVersionFlag(String buTreeCode);

    /**
     * 根据id删除草稿状态的组织树
     * @param id 组织树id
     */
    void deleteBuTreeById(Long id);


    /**
     * 通过buTreeCode 版本号查询组织树
     * @param buTreeCode 组织树code
     * @param nowVersion 版本号
     * @return
     */
    OrgBuTreeDTO findByBuTreeCodeAndNowVersion(String buTreeCode, String nowVersion);

}
