package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreePagingDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDetailVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreePagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeVersionDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeDRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Service
@RequiredArgsConstructor
public class OrgBuTreeServiceImpl implements OrgBuTreeService {

    private final OrgBuTreeDomainService orgBuTreeDomainService;
    private final OrgBuTreeVersionDomainService orgBuTreeVersionDomainService;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    /**
     * 组织树新增、编辑
     *
     * @param param
     * @return
     */
    @Override
    @CacheEvict(cacheNames = "ORG_BU_TREE", key = "'BU_TREE_ID_' + #param.id", condition = "#param.id != null && !#param.id.isEmpty()")
    @Transactional(rollbackFor = Exception.class)
    public Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param) {
        return orgBuTreeDomainService.orgBuTreeSaveOrUpdate(param);
    }

    /**
     * 通过id获取组织树详细信息，包含树状结构
     *
     * @param id
     * @return
     */
    @SysCodeProc
    @Override
    public OrgBuTreeDetailVO getOrgBuTreeDetailById(Long id) {
        OrgBuTreeDetailDTO result = orgBuTreeDomainService.getOrgBuTreeDetailById(id);
        return OrgTreeConvert.INSTANCE.dtoToVo(result);
    }

    /**
     * 通过id获取组织树详细信息，包含树状结构
     */
    @SysCodeProc
    @Override
    public OrgBuTreeDO getOrgBuTreeDetailByCode(String code) {
        OrgBuTreeDO orgBuTreeDO=  orgBuTreeRepo.findByBuTreeCode(code).orElse(null);
        return orgBuTreeDO;
    }

    /**
     * 组织树分页条件查询
     *
     * @param param
     * @return
     */
    @Override
    @SysCodeProc
    public PagingVO<OrgBuTreePagingVO> queryOrgBuTreeByParams(OrgBuTreePagingParam param) {
        PagingVO<OrgBuTreePagingDTO> result = orgBuTreeDomainService.queryOrgBuTreeByParams(param);
        List<OrgBuTreePagingDTO> records = result.getRecords();

        return PagingVO.<OrgBuTreePagingVO>builder()
                .records(OrgTreeConvert.INSTANCE.treePDtoToVo(records))
                .total(result.getTotal())
                .build();
    }

    /**
     * 组织树确认、停用
     *
     * @param param 参数
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(OrgBuTreeStatusParam param) {
        orgBuTreeDomainService.updateStatus(param);
    }

    /**
     * 根据param获取组织树履历数据
     *
     * @param param param
     * @return 分页数据
     */
    @Override
    public PagingVO<OrgBuTreeVO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        PagingVO<OrgBuTreeDTO> result = orgBuTreeDomainService.getBuTreePagingByParam(param);
        List<OrgBuTreeDTO> records = result.getRecords();

        return PagingVO.<OrgBuTreeVO>builder()
                .records(OrgTreeConvert.INSTANCE.treeDtoToVo(records))
                .total(result.getTotal())
                .build();
    }

    /**
     * 根据组织树编码获取是否可以创建新版本组织树标识
     *
     * @param buTreeCode
     * @return
     */
    @Override
    public Boolean getCreateNewVersionFlag(String buTreeCode) {
        return orgBuTreeDomainService.getCreateNewVersionFlag(buTreeCode);
    }

    /**
     * 根据id删除草稿状态的组织树
     *
     * @param id 组织树id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBuTreeById(Long id) {
        orgBuTreeDomainService.deleteBuTreeById(id);
    }


}
