package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.Optional;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@Repository
public interface OrgBuTreeRepo extends JpaRepository<OrgBuTreeDO, Long>, QuerydslPredicateExecutor<OrgBuTreeDO> {

    /**
     * 检查是否有重复的buTreeCode
     * @param buTreeCode
     * @return
     */
    boolean existsByBuTreeCode(String buTreeCode);

    /**
     * 通过buTreeCode查询组织树
     * @param buTreeCode
     * @return
     */
    Optional<OrgBuTreeDO> findByBuTreeCode(String buTreeCode);

    /**
     * 除自己外，检查是否有重复的 buTreeCode
     * @param buTreeCode 组织树编号
     * @Param nowVersion 版本
     * @param id id
     * @return 是否重复
     */
    boolean existsByBuTreeCodeAndNowVersionAndIdNot(String buTreeCode,String nowVersion, Long id);

    /**
     * 通过buTreeCode 是否当前版本查询组织树
     * @param buTreeCode
     * @return
     */
    Optional<OrgBuTreeDO> findByBuTreeCodeAndIsNowVersion(String buTreeCode,Boolean isNowVersion);

    /**
     * 通过buTreeCode 版本号查询组织树
     * @param buTreeCode 组织树code
     * @param nowVersion 版本号
     * @return
     */
    Optional<OrgBuTreeDO> findByBuTreeCodeAndNowVersion(String buTreeCode,String nowVersion);
}
