package com.elitescloud.cloudt.system.modules.warning.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRecordDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRecordNoticeDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.QSysWarningRuleDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordPageQueryVO;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/8/4 周一
 */
@Repository
public class SysWarningRecordRepoProc extends BaseRepoProc<SysWarningRecordDO> {
    private static final QSysWarningRecordDO QDO = QSysWarningRecordDO.sysWarningRecordDO;
    private static final QSysWarningRuleDO QDO_RULE = QSysWarningRuleDO.sysWarningRuleDO;
    private static final QSysWarningRecordNoticeDO QOD_NOTICE = QSysWarningRecordNoticeDO.sysWarningRecordNoticeDO;

    public SysWarningRecordRepoProc() {
        super(QDO);
    }

    public PagingVO<SysWarningRecordDO> pageQuery(SysWarningRecordPageQueryVO queryVO, Collection<Long> userIds) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.scene, queryVO.getScene())
                .andLike(QDO.ruleCode, queryVO.getRuleCode())
                .andIn(StrUtil.isNotBlank(queryVO.getRuleName()), QDO.ruleCode, () -> JPAExpressions.select(QDO_RULE.ruleCode).from(QDO_RULE).where(QDO_RULE.ruleName.like(queryVO.getRuleName())))
                .and(queryVO.getSuccess() != null, () -> Boolean.TRUE.equals(queryVO.getSuccess()) ? QDO.numSuccess.eq(QDO.numTotal) : QDO.numFail.gt(0))
                .andBetween(QDO.execTime, queryVO.getExecTimeStart(), queryVO.getExecTimeEnd())
                .and(CollUtil.isNotEmpty(userIds), () -> JPAExpressions.select(QOD_NOTICE.id).from(QOD_NOTICE).where(QOD_NOTICE.masId.eq(QDO.id).and(QOD_NOTICE.noticeUserId.in(userIds))).exists())
                .build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), QDO.execTime.desc());
    }
}
