package com.elitescloud.cloudt.system.modules.wecom.service;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.modules.wecom.model.login.WecomLoginPropsVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * 企微认证服务.
 *
 * @author Kaiser（wang shao）
 * @date 2024/12/1
 */
public interface WecomAuthService {

    /**
     * 获取登录参数
     * <p>
     * <a href = 'https://developer.work.weixin.qq.com/document/path/98478'>创建企业微信登录面板</a>
     *
     * @return 参数
     */
    ApiResult<WecomLoginPropsVO> getLoginProps();

    /**
     * 获取认证地址
     *
     * @param redirectUri 认证地址
     * @param state       自定义参数
     * @return 结果
     */
    ApiResult<String> getAuthorizeUrl(@NotBlank String redirectUri, String state);

    /**
     * 授权码换token
     * <p>
     * <a href='https://developer.work.weixin.qq.com/document/path/98176'>获取用户登录身份</a>
     *
     * @param code 授权码
     * @return token
     */
    ApiResult<OAuthToken> code2Token(HttpServletRequest request, HttpServletResponse response, @NotBlank String code);
}
