package com.elitescloud.cloudt.system.provider.mq;

import com.elitescloud.boot.provider.TenantClientProvider;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/5/23
 */
@Log4j2
@SuppressWarnings({"deprecation", "removal"})
//@Component
public class SystemCloudStreamListener {

    @Autowired
    private TenantClientProvider tenantClientProvider;

    @StreamListener(SystemMqBinding.INPUT_SYSTEM)
    public void test(String msg) {
        log.info("接收到消息：{}", msg);
        log.info("租戶：{}", tenantClientProvider.getSessionTenant());
    }
}
