package com.elitescloud.cloudt.system.provider.usersync;

import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
public interface UserSyncProvider<T extends Serializable, P extends Serializable> {

    /**
     * 系统编码
     *
     * @return 系统编码
     */
    String sysCode();

    /**
     * 系统名称
     *
     * @return 系统名称
     */
    String sysName();

    /**
     * 是否启用
     *
     * @return 是否启用
     */
    default boolean enabled() {
        return true;
    }

    /**
     * 获取同步地址
     *
     * @return 同步地址
     */
    String getSyncUrl();

    /**
     * 转换同步数据
     *
     * @param request 请求
     * @param userDTO 账号信息
     * @param reqData 自定义请求数据
     * @return 同步数据
     */
    P convertSyncData(HttpServletRequest request, SysUserBasicDTO userDTO, T reqData);

    /**
     * 同步账号信息
     *
     * @return 同步结果
     */
    SyncUserResult syncUser(Long userId, P syncData);
}
