package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import com.elitescloud.cloudt.system.service.TaxRateQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/7/2023
 */
@RestController
@RequestMapping(value = SysTaxRateRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysTaxRateRpcServiceImpl implements SysTaxRateRpcService {

    private TaxRateQueryService queryService;

    @Override
    public ApiResult<SysTaxRateRespDTO> getByTaxRateNo(String taxRateNo) {
        return queryService.getByTaxRateNo(taxRateNo);
    }

    @Override
    public ApiResult<List<SysTaxRateRespDTO>> queryList(SysTaxRateQueryDTO queryDTO) {
        return queryService.queryList(queryDTO);
    }

    @Autowired
    public void setQueryService(TaxRateQueryService queryService) {
        this.queryService = queryService;
    }
}
