package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.BuTreeNodeQueryEmployeeDTO;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePagedRespDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeQueryEmployeeParam;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDService;
import com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgTreeRpcService;
import org.springframework.beans.BeanUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@RestController
@RequestMapping(value = OrgTreeRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class OrgTreeRpcServiceImpl implements OrgTreeRpcService {
    private final OrgBuTreeDService orgBuTreeDService;

    public OrgTreeRpcServiceImpl(OrgBuTreeDService orgBuTreeDService) {
        this.orgBuTreeDService = orgBuTreeDService;
    }

    @Override
    public ApiResult<List<EmployeePagedRespDTO>> buTreeNodeQueryEmployee(BuTreeNodeQueryEmployeeDTO param) {
        BuTreeNodeQueryEmployeeParam buTreeNodeQueryEmployeeParam = new BuTreeNodeQueryEmployeeParam();
        buTreeNodeQueryEmployeeParam.setBuTreeId(param.getBuTreeId());
        buTreeNodeQueryEmployeeParam.setBuId(param.getBuId());
        buTreeNodeQueryEmployeeParam.setBuCode(param.getBuCode());
        ApiResult<List<EmployeePagedRespVO>> voResult =
                orgBuTreeDService.buTreeNodeQueryEmployee(buTreeNodeQueryEmployeeParam);
        if (voResult != null && voResult.getData() != null && voResult.getData().size() > 0) {
            List<EmployeePagedRespDTO> apiResult =
                    voResult.getData().stream().map(employeePagedRespVO -> {
                        EmployeePagedRespDTO employeePagedRespDTO = new EmployeePagedRespDTO();
                        BeanUtils.copyProperties(employeePagedRespVO, employeePagedRespDTO);
                        return employeePagedRespDTO;
                    }).collect(Collectors.toList());
            return ApiResult.ok(apiResult);
        } else {
            return ApiResult.ok();
        }
    }

    @Override
    public ApiResult<List<EmpOrgTreeOrgDTO>> searchByOrgTreeCodeAndEmpId(SearchByOrgTreeCodeAndEmpIdParam param) {
       return orgBuTreeDService.searchOrgByOrgTreeCodeAndEmpId(param);
    }
}
