package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;

/**
 * 账号认证授权服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/16
 */
public interface AuthUserService {

    /**
     * 用户认证
     *
     * @param request  请求
     * @param response 响应
     * @param idType   账户标识类型，{@link com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter.IdType}，默认为登录号
     * @param id       账户标识
     * @return token
     */
    ApiResult<OAuthToken> authenticate(HttpServletRequest request, HttpServletResponse response,
                                       String idType, @NotBlank String id);

    /**
     * 用户认证
     *
     * @param request    请求
     * @param response   响应
     * @param idType     账户标识类型，{@link com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter.IdType}，默认为登录号
     * @param idEncoded  加密的账户标识
     * @param cipherType 加密类型，{@link com.elitescloud.cloudt.system.common.IdEncodedTypeEnum}，默认为RSA加密
     * @return token
     */
    ApiResult<OAuthToken> authenticateForEncoded(HttpServletRequest request, HttpServletResponse response,
                                                 String idType, @NotBlank String idEncoded, String cipherType);

    /**
     * ticket换token
     *
     * @param ticket ticket值
     * @return token值（不含token类型Bearer）
     */
    ApiResult<String> ticket2Token(@NotBlank String ticket);
}
