package com.elitescloud.cloudt.system.service;

import cn.hutool.core.text.StrPool;
import com.elitescloud.cloudt.system.model.vo.BotRequest;
import com.elitescloud.cloudt.system.util.DateUtils;
import com.elitescloud.cloudt.system.util.SnsBotUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:27
 * @Description:
 */
@Slf4j
@RequiredArgsConstructor
public class BotMessageDefaultBuilder implements BotMessageBuilder {
    @Override
    public String templateBuilder(BotRequest request) {
        return "> 调用方式：" + request.getSnsMode() + StrPool.LF +
                "> 异常类型：<font color='red'>" + request.getSnsType() + "</font>" + StrPool.LF +
                "> 异常单据类型：" + request.getSnsScene() + StrPool.LF +
                "> 时间：" + DateUtils.nowStr() + StrPool.LF +
                "> TraceID：" + TraceContext.traceId() + StrPool.LF +
                "> 异常信息：" + SnsBotUtil.concat(request.getMessages());
    }
}
