package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.DataRelationQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.DataRelationRespDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataRelationRespVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/22
 */
public interface DataRelationInstQueryService {

    /**
     * 根据主数据查询被关联的数据
     *
     * @param queryDTO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<DataRelationRespDTO>> query(@NotNull DataRelationQueryDTO queryDTO);

    /**
     * 根据被关联的数据查询主数据
     *
     * @param queryDTO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<DataRelationRespDTO>> queryByRefData(@NotNull DataRelationQueryDTO queryDTO);

    /**
     * 根据主数据查询被关联的数据
     *
     * @param queryVO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<CommonDataRelationRespVO>> query(@NotNull CommonDataRelationQueryVO queryVO);

    /**
     * 根据被关联的数据查询主数据
     *
     * @param queryVO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<CommonDataRelationRespVO>> queryByRefData(@NotNull CommonDataRelationQueryVO queryVO);
}
