package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonMenuTreeNodeRespVO;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/28
 */
public interface MenuQueryService {

    /**
     * 系统菜单树
     *
     * @param appCode      指定应用
     * @param withSys      是否显示管理菜单
     * @param withBusiness 是否显示业务菜单
     * @param withMenu     是否显示菜单
     * @param withAction   是否显示操作按钮
     * @param tree         是否返回树状
     * @return 菜单树
     */
    ApiResult<List<CommonMenuTreeNodeRespVO>> menuTreeSystem(String appCode, Boolean withSys, Boolean withBusiness,
                                                             Boolean withMenu, Boolean withAction, Boolean defTree, Boolean tree);

    /**
     * 获取菜单信息
     *
     * @param menuCode 菜单编码
     * @return
     */
    ApiResult<SysPlatformMenusDTO> getMenuInfo(@NotBlank String menuCode);

    /**
     * 获取菜单信息
     *
     * @param menuCodes 菜单编码
     * @return
     */
    ApiResult<List<SysPlatformMenusDTO>> getMenuInfo(Set<String> menuCodes);

    /**
     * 获取菜单及其上级菜单
     *
     * @param menuCode
     * @return
     */
    ApiResult<List<IdCodeNameParam>> getMenuWithParents(@NotBlank String menuCode);
}
