package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.model.vo.query.position.*;

import java.util.List;

/**
 * @author : chen.niu
 * @description : 岗位管理
 * @date : 2024-05-13 16:26
 */
public interface SysPositionService {
    ApiResult<List<SysPositionVo>> getAllPositions(SysPositionQueryVo sysPositionVo);

    ApiResult< SysPositionVo> getPositionById(Long id);

    ApiResult<Long> createPosition(SysPositionSaveVo position);

    ApiResult<Boolean> updatePosition(Long id, SysPositionSaveVo newPosition);

    ApiResult<Boolean> deletePosition(Long id);

    ApiResult<Boolean> deleteAllById(List<Long> id);

    List<OrgVo> findOrgsByPosition(String positionCode);

    List<RoleVo> findRolesByPosition(String positionCode);

    ApiResult<SysPositionVo> getPositionByCode(String positionCode);
}
