package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.PwdStrategySaveVO;

import java.util.List;

/**
 * 系统管理服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/5
 */
public interface SystemMngService {

    /**
     * 保存密码安全策略
     *
     * @param saveVOList 密码安全策略
     * @return 平台ID
     */
    ApiResult<Boolean> save(List<PwdStrategySaveVO> saveVOList);

    /**
     * 获取策略配置
     *
     * @return 配置
     */
    ApiResult<PwdStrategyConfigRespVO> getPwdStrategy();

    /**
     * 获取策略配置
     *
     * @return 配置
     */
    ApiResult<PwdStrategyConfigRespVO> getDefaultPwdStrategy();
}
