package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.CommonTenantAppVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAppPageQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRateQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.*;
import com.elitescloud.cloudt.system.model.vo.resp.sys.PwdStrategyRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/11
 */
public interface SystemQueryService {

    /**
     * 查询应用列表
     *
     * @return 应用列表
     */
    ApiResult<List<CommonTenantAppVO>> listApp(Boolean outerApp, Boolean authed);

    /**
     * 分页查询应用
     *
     * @param queryVO 查询参数
     * @return 应用列表
     */
    ApiResult<PagingVO<CommonTenantAppVO>> pageApp(CommonAppPageQueryVO queryVO);

    /**
     * 查询行政区域列表
     *
     * @param queryVO 查询参数
     * @return 行政区域列表
     */
    ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaQueryVO queryVO);

    /**
     * 查询行政区域树
     *
     * @param queryVO 查询参数
     * @return 行政区域树
     */
    ApiResult<List<CommonAreaTreeRespVO>> treeArea(CommonAreaTreeQueryVO queryVO);

    /**
     * 查询货币列表
     *
     * @return 货币列表
     */
    ApiResult<List<CodeNameParam>> listCurrency();

    /**
     * 查询税率列表
     *
     * @param taxRateNo   税率编码
     * @param taxRateType 税率类型
     * @return 税率列表
     */
    ApiResult<List<CommonTaxRateRespVO>> listTaxRate(String taxRateNo, String taxRateType);

    /**
     * 查询汇率
     *
     * @param queryVO 查询参数
     * @return 汇率
     */
    ApiResult<Double> queryCurrentRate(CurrencyRateQueryVO queryVO);

    /**
     * 获取开户（修改）密码时的密码策略
     *
     * @return 密码策略列表
     */
    ApiResult<List<PwdStrategyRespVO>> listPwdStrategyForCreateAccount();

    /**
     * 获取外部应用设置
     *
     * @return 外部应用设置
     */
    ApiResult<List<OuterAppSettingRespVO>> listOuterAppSettings();

    /**
     * 查询数据选择器
     *
     * @param tree
     * @return
     */
    ApiResult<List<CommonDataSelectorListRespVO>> listTree(Boolean tree);


    /**
     * 根据主数据查询被关联的数据
     *
     * @param queryVO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<CommonDataRelationRespVO>> queryRelation(@NotNull CommonDataRelationQueryVO queryVO);

    /**
     * 根据被关联的数据查询主数据
     *
     * @param queryVO 查询参数
     * @return 关联的数据列表
     */
    ApiResult<List<CommonDataRelationRespVO>> queryRelationByRefData(@NotNull CommonDataRelationQueryVO queryVO);

    /**
     * 分页查询UDC
     *
     * @param queryVO 查询参数
     * @return UDC列表
     */
    ApiResult<PagingVO<UdcWithValuesPageRespVO>> pageQueryUdc(UdcPageQueryVO queryVO);
}
