package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TaxRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TaxRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TaxRateSaveVO;

/**
 * 税率管理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/1
 */
public interface TaxRateMngService {

    /**
     * 保存税率
     *
     * @param saveVO 税率信息
     * @return 税率ID
     */
    ApiResult<Long> save(TaxRateSaveVO saveVO);

    /**
     * 删除税率信息
     *
     * @param id 税率ID
     * @return 税率ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 税率ID
     * @return 切换结果
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 分页查询税率
     *
     * @param queryVO 查询参数
     * @return 税率列表
     */
    ApiResult<PagingVO<TaxRatePageRespVO>> page(TaxRatePageQueryVO queryVO);

    /**
     * 获取税率详情
     *
     * @param id 税率ID
     * @return 税率详情
     */
    ApiResult<TaxRateDetailRespVO> get(Long id);
}
