package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.user.sync.UserSyncRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.sync.UserSyncRecordDetailRespVO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
public interface UserSyncMngService {

    /**
     * 分页查询同步信息
     *
     * @param queryVO
     * @return
     */
    ApiResult<PagingVO<UserSyncRecordDetailRespVO>> pageQuery(UserSyncRecordPageQueryVO queryVO);

    /**
     * 同步账号
     *
     * @param outerSysCode 外部系统编码
     * @param userId       用户ID
     * @param syncData     同步信息
     * @return 用户ID
     */
    ApiResult<Long> syncUser(@NotBlank String outerSysCode, Long userId, Object syncData);

    /**
     * 获取账号的同步记录
     *
     * @param outerSysCode
     * @param userId
     * @return
     */
    ApiResult<List<UserSyncRecordDetailRespVO>> listSyncRecord(@NotBlank String outerSysCode, Long userId);
}
