package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.elitescloud.cloudt.system.constant.SysConstant;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionConvert;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeOrgInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeOrgInfoSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeOrgSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.provider.imports.param.ImportEmployeeBO;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.manager.EmployeeMngManager;
import com.elitescloud.cloudt.system.service.manager.EmployeeQueryManager;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.bo.*;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.PositionRepoProc;
import com.google.common.base.Functions;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/8
 */
@Service
@Log4j2
@TenantTransaction(isolateType = TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg = false)
public class EmployeeMngServiceImpl extends EmployeeBaseServiceImpl implements EmployeeMngService {
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private EmployeeMngManager employeeMngManager;
    @Autowired
    private EmployeeQueryManager employeeQueryManager;
    @Autowired
    private PermissionMngManager permissionManager;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private PositionRepoProc positionRepoProc;

    @Autowired
    private UserMngService userMngService;

    @Override
    public ApiResult testUpdate(EmployeeSaveVO saveVO) {
        Map map=null;
        if(saveVO.getExtensionAll()){
            map =new HashMap();
            map.put("test","test");
            map.put("22","33");
        }
        SysEmployeeDO sysEmployeeDO=new SysEmployeeDO();
        sysEmployeeDO.setUserId(0L);
        sysEmployeeDO.setRootOrgId(0L);
        sysEmployeeDO.setUsername("");
        sysEmployeeDO.setLastName("");
        sysEmployeeDO.setFirstName("");
        sysEmployeeDO.setGender("");
        sysEmployeeDO.setNickName("");
        sysEmployeeDO.setBirthDate(LocalDate.now());
        sysEmployeeDO.setCode("222test123");
        sysEmployeeDO.setType("");
        sysEmployeeDO.setDuty("");
        sysEmployeeDO.setPhoto("");
        sysEmployeeDO.setContractStartTime(LocalDateTime.now());
        sysEmployeeDO.setContractEndTime(LocalDateTime.now());
        sysEmployeeDO.setJoinTime(LocalDateTime.now());
        sysEmployeeDO.setPhone("");
        sysEmployeeDO.setEmailWork("");
        sysEmployeeDO.setMobile("");
        sysEmployeeDO.setEmail("");
        sysEmployeeDO.setIdCard("");
        sysEmployeeDO.setLeaveTime(LocalDateTime.now());
        sysEmployeeDO.setServed(false);
        sysEmployeeDO.setEnabled(false);
        sysEmployeeDO.setSortNo(0);
        sysEmployeeDO.setCountryCode("");
        sysEmployeeDO.setProvinceCode("");
        sysEmployeeDO.setCityCode("");
        sysEmployeeDO.setCountyCode("");
        sysEmployeeDO.setAddress("");
        sysEmployeeDO.setPersonalSign("");
        sysEmployeeDO.setAvatarUrl("");
        sysEmployeeDO.setAvatarCode("");
        sysEmployeeDO.setExtensionInfo(map);

        employeeRepoProc.save(sysEmployeeDO);

     var d=   employeeRepoProc.getByCode(sysEmployeeDO.getCode());
    System.out.println(d.get());
        employeeRepoProc.delete(d.get().getId());
//        SysEmployeeDO sysEmployeeDO = employeeRepoProc.getOptional(saveVO.getId()).orElseThrow();
//        if (saveVO.getExtensionAll()) {
//            sysEmployeeDO.setExtensionInfo(saveVO.getExtensionInfo());
//        } else {
//            try {
//                Map<String, String> existingInfo = sysEmployeeDO.getExtensionInfo();
//                updateMergeExtensionInfo(saveVO.getExtensionInfo(), existingInfo);  // 将新信息合并到现有信息中
//                sysEmployeeDO.setExtensionInfo(existingInfo);  // 重新设置合并后的Map
//                // employeeRepoProc.save(sysEmployeeDO);
//            } catch (Exception e) {
//                e.getMessage();
//            }
//
//            QSysEmployeeDO qEmployee = QSysEmployeeDO.sysEmployeeDO;
//            employeeRepoProc.updateJsonField(qEmployee, qEmployee.extensionInfo,
//                    saveVO.getExtensionInfo(), qEmployee.id.eq(saveVO.getId()));
//        }
//        QSysEmployeeDO qEmployee = QSysEmployeeDO.sysEmployeeDO;
//
//
        return ApiResult.ok();
    }

    private void updateMergeExtensionInfo(Map<String, String> sourceParamInfo, Map<String, String> targetDoInfo) {
        targetDoInfo.putAll(sourceParamInfo);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> upsert(EmployeeSaveVO saveVO) {
        Long employeeId = ObjectUtil.defaultIfNull(saveVO.getId(), saveVO.getEmployeeOrgInfo().getId());
        // 转换为BO信息
        var saveBO = this.toEmployeeSaveBO(saveVO.getEmployeeOrgInfo(), employeeId);
        saveBO.setWithoutLoginAccount(saveVO.getWithoutLoginAccount());
        var userSaveBO = this.toUserSaveBO(saveVO.getUserInfo(), employeeId);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setUserId(userSaveBO.getId());
        saveBO.setEnabled(ObjectUtil.defaultIfNull(userSaveBO.getEnabled(), true));
        saveBO.setExtensionInfo(saveVO.getExtensionInfo());
        // 保存员工和账号信息
        var employeeDO = employeeMngManager.upsert(saveBO);

        return ApiResult.ok(employeeDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<String> upsert(EmployeeUpsertDTO upsertDTO) {
        // 转换为BO信息
        var saveBO = this.toEmployeeSaveBO(upsertDTO);
        var userSaveBO = this.toUserSaveBO(upsertDTO);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setUserId(userSaveBO.getId());
        saveBO.setEnabled(ObjectUtil.defaultIfNull(userSaveBO.getEnabled(), true));

        // 保存员工和账号信息
        var employeeDO = employeeMngManager.upsert(saveBO);

        return ApiResult.ok(employeeDO.getCode());
    }

    @Override
    public ApiResult<List<String>> checkForUpsert(List<EmployeeUpsertDTO> upsertDTOList) {
        List<String> msgList = new ArrayList<>();
        for (EmployeeUpsertDTO upsertDto : upsertDTOList) {
            try {
                var saveBO = this.toEmployeeSaveBO(upsertDto);
                var userSaveBO = this.toUserSaveBO(upsertDto);
                saveBO.setUserSaveBO(userSaveBO);
                saveBO.setUserId(userSaveBO.getId());

                employeeMngManager.check(saveBO);
                msgList.add(null);
            } catch (Exception e) {
                msgList.add(ExceptionUtil.getRootCauseMessage(e));
            }
        }
        return ApiResult.ok(msgList);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> importEmployee(ImportEmployeeBO employeeBO) {
        // 转换为BO信息
        var saveBO = this.toEmployeeSaveBO(employeeBO);
        var userSaveBO = this.toUserSaveBO(employeeBO);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setWithoutLoginAccount(employeeBO.getWithoutLoginAccount());

        // 保存员工和账号信息
        var employeeDO = employeeMngManager.upsert(saveBO);

        // 角色
        if (CollUtil.isNotEmpty(employeeBO.getRoleIds()) && Boolean.FALSE.equals(employeeBO.getWithoutLoginAccount())) {
            permissionManager.saveUserRole(employeeDO.getUserId(), new ArrayList<>(employeeBO.getRoleIds()));
        }

        return ApiResult.ok(employeeDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> upsertUser(Long orgId, UserSaveVO saveVO) {
        // 保存账号信息
        var userSaveBO = this.toUserSaveBO(saveVO, null);
        var employeeDO = employeeMngManager.upsert(userSaveBO, orgId);

        return ApiResult.ok(employeeDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> upsertOrg(EmployeeOrgInfoSaveVO saveVO) {
        var saveBO = this.toEmployeeSaveBO(saveVO, null);
        var employeeDO = employeeMngManager.upsert(saveBO);

        return ApiResult.ok(employeeDO.getId());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> updateEnabled(Long id) {
        var enabled = employeeRepoProc.getEnabled(id);
        enabled = enabled == null || !enabled;

        employeeMngManager.updateEnabled(id, enabled);
        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<String> updateEnabledByCode(String code, Boolean enabled) {
        var id = employeeRepoProc.getIdByCode(code);
        if (id == null) {
            return ApiResult.fail("员工不存在");
        }

        enabled = enabled != null && enabled;
        employeeMngManager.updateEnabled(id, enabled);

        return ApiResult.ok(code);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> updateMobile(Long id, String mobile, Boolean updateUser) {
        employeeMngManager.updateMobile(id, mobile, updateUser);
        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> updateEmail(Long id, String email, Boolean updateUser) {
        employeeMngManager.updateEmail(id, email, updateUser);
        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> saveEmployeeOrg(Long id, List<EmployeeOrgSaveVO> orgSaveVoList) {
        var orgSaveBoList = orgSaveVoList.stream().filter(t -> t.getOrgId() != null)
                .map(t -> {
                    SysEmployeeOrgSaveBO saveBO = new SysEmployeeOrgSaveBO();
                    saveBO.setOrgId(t.getOrgId());
                    saveBO.setLeaderUserId(t.getLeaderUserId());
                    saveBO.setPositionId(t.getPositionId());
                    return saveBO;
                }).collect(Collectors.toList());
        employeeMngManager.saveEmployeeOrg(id, orgSaveBoList);
        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> delete(Long id, Boolean keepUser) {
        employeeMngManager.deleteEmployee(id, keepUser);

        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Long> saveRole(Long id, List<Long> roleIds) {
        var userId = employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail("未知员工账号信息");
        }
        permissionManager.saveUserRole(userId, roleIds);

        return ApiResult.ok(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Boolean> bindSalesman(Long id, String salesmanId) {
        if (id == null) {
            return ApiResult.fail("员工ID为空");
        }

        var userId = employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail("员工账号不存在");
        }

        if (CharSequenceUtil.isBlank(salesmanId)) {
            // 解绑
            var res = userMngService.removeUserType(userId, UserType.SALESMAN.getValue(), salesmanId);
            return res.isSuccess() ? ApiResult.ok(true) : ApiResult.fail(res.getMsg());
        }
        var res = userMngService.addUserType(userId, UserType.SALESMAN.getValue(), salesmanId);
        return res.isSuccess() ? ApiResult.ok(true) : ApiResult.fail(res.getMsg());
    }

    @Override
    public ApiResult<EmployeeDetailRespVO> getDetail(Long id) {
        // 获取员工信息
        var employeeDO = employeeRepoProc.get(id);
        if (employeeDO == null) {
            return ApiResult.noData();
        }

        EmployeeDetailRespVO respVO = new EmployeeDetailRespVO();
        respVO.setWithoutLoginAccount(employeeDO.getUserId() == null || employeeDO.getUserId() == SysConstant.NO_USER_ID);
        // 获取账号信息
        UserDetailRespVO userInfo = null;
        if (!respVO.getWithoutLoginAccount()) {
            userInfo = userMngService.get(employeeDO.getUserId()).getData();
        }
        if (userInfo == null) {
            userInfo = EmployeeConvert.INSTANCE.convertUserInfo(employeeDO);
            userInfo.setId(null);
        } else {
            userInfo.setEnabled(employeeDO.getEnabled());
        }
        respVO.setUserInfo(userInfo);
        // 员工组织信息
        respVO.setEmployeeOrgInfo(getEmployeeOrgInfo(employeeDO));

        return ApiResult.ok(respVO);
    }

    @Override
    public ApiResult<List<EmpOrgRespVO>> getEmployeeOrgs(Long id) {
        // 查询组织
        var orgWithParentMap = employeeQueryManager.getEmployeeOrgsWithParent(id).stream()
                .collect(Collectors.toMap(t -> t.get(t.size() -1).getId(), Functions.identity(), (t1, t2) -> t1));
        if (orgWithParentMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }

        var employeeOrgList = employeeOrgRepoProc.getEmployeeOrgByEmployeeId(id);
        var leaderEmpIds = employeeOrgList.stream().map(SysEmployeeOrgDO::getLeaderEmployeeId).filter(ObjUtil::isNotNull).collect(Collectors.toSet());
        var postIds = employeeOrgList.stream().map(SysEmployeeOrgDO::getPositionId).filter(ObjUtil::isNotNull).collect(Collectors.toSet());

        Map<Long, IdCodeNameParam> leaderMap = leaderEmpIds.isEmpty() ? Collections.emptyMap() : employeeRepoProc.queryEmployeeName(leaderEmpIds).stream()
                .collect(Collectors.toMap(IdCodeNameParam::getId, Function.identity(), (t1, t2) -> t1));
        Map<Long, SysPositionDO> positionMap = postIds.isEmpty() ? Collections.emptyMap() : positionRepoProc.get(postIds).stream()
                .collect(Collectors.toMap(SysPositionDO::getId, Functions.identity(), (t1, t2) -> t1));

        var respVOList = employeeOrgList.stream()
                .filter(t -> orgWithParentMap.containsKey(t.getOrgId()))
                .map(t -> {
                    EmpOrgRespVO respVO = new EmpOrgRespVO();
                    respVO.setDetails(orgWithParentMap.get(t.getOrgId()));
                    respVO.setDef(Boolean.TRUE.equals(t.getDef()));
                    respVO.setAssignee(Boolean.TRUE.equals(t.getAssignee()));

                    // 领导信息
                    IdCodeNameParam leader = t.getLeaderEmployeeId() == null ? null : leaderMap.get(t.getLeaderEmployeeId());
                    if (leader != null) {
                        respVO.setLeaderUserId(t.getLeaderUserId());
                        respVO.setLeaderUserName(leader.getName());
                    }

                    // 岗位信息
                    SysPositionDO position = t.getPositionId() == null ? null : positionMap.get(t.getPositionId());
                    if (position != null) {
                        respVO.setPositionVo(SysPositionConvert.INSTANCE.doToVo(position));
                    }

                    return respVO;
                }).collect(Collectors.toList());
        return ApiResult.ok(respVOList);
    }

    @Override
    public ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeOrgs(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(Collections.emptyMap());
        }

        var data = employeeOrgRepoProc.getEmployeeOrgs(ids, true);
        return ApiResult.ok(data);
    }

    @Override
    public ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeRolesByUserIds(List<Long> userIds) {
        if (CollUtil.isEmpty(userIds)) {
            return ApiResult.ok(Collections.emptyMap());
        }

        var data = permissionQueryManager.queryUserRoles(new HashSet<>(userIds));
        return ApiResult.ok(data);
    }

    @Override
    public ApiResult<List<IdCodeNameCheckParam>> getRole(Long id) {
        var userId = employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail("未知员工账号信息");
        }

        var roleList = permissionManager.getUserRole(userId, false);
        return ApiResult.ok(roleList);
    }

    @Override
    public ApiResult<PagingVO<EmployeePagedRespVO>> page(EmployeePageQueryVO queryVO) {
        // 查询员工
        var pageData = employeeRepoProc.pageMng(queryVO, null);
        if (pageData.isEmpty()) {
            return ApiResult.ok(PagingVO.empty());
        }

        // 填充信息
        this.fillPage(pageData.getRecords(), null, queryVO.getWithRole());

        return ApiResult.ok(pageData);
    }

    @Override
    public void fillPage(List<EmployeePagedRespVO> pageData, Map<Long, SysUserBasicDTO> userMap, Boolean withRole) {
        if (CollUtil.isEmpty(pageData)) {
            return;
        }
        var employeeTypeMap = udcMap(new EmployeeType());
        var userIds = pageData.stream().map(EmployeePagedRespVO::getUserId).filter(t -> t != null && t != SysConstant.NO_USER_ID).collect(Collectors.toSet());
        // 角色
        Map<Long, List<IdCodeNameParam>> roleMap = Boolean.TRUE.equals(withRole) ? permissionQueryManager.queryUserRoles(userIds) : Collections.emptyMap();

        pageData.forEach(t -> {
            // 员工类型
            if (StringUtils.hasText(t.getType())) {
                t.setTypeName(employeeTypeMap.get(t.getType()));
            }

            t.setWithoutLoginAccount(t.getUserId() == null || t.getUserId() == SysConstant.NO_USER_ID);
            t.setRoleNameList(roleMap.getOrDefault(t.getUserId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
        });

        // 填充用户信息
        fillUserInfo(pageData, userMap);
    }

    private SysUserSaveBO toUserSaveBO(UserSaveVO saveVO, Long employeeId) {
        Long userId = saveVO.getId();
        if (userId == null && employeeId != null) {
            // 根据员工ID查询用户ID
            userId = employeeRepoProc.getRealUserId(employeeId);
            Assert.notNull(userId, "未知员工所属账号");
            saveVO.setId(userId);
        }

        // 转为BO
        SysUserSaveBO userSaveBO = null;
        if (userId == null || userId == SysConstant.NO_USER_ID) {
            userSaveBO = CONVERT_USER.vo2SaveBo(saveVO);
        } else {
            // 先查询出原有信息
            Long finalUserId = userId;
            var userDO = this.userRepoCall(proc -> proc.get(finalUserId));
            Assert.notNull(userDO, "员工所属账号不存在");
            userSaveBO = CONVERT_USER.do2SaveBo(userDO);
            CONVERT_USER.copy2SaveBo(saveVO, userSaveBO);
        }

        // 行政区域
        AreaBO areaBO = AreaConvert.INSTANCE.vo2Bo(saveVO.getAreaVO());
        userSaveBO.setAreaBO(areaBO);

        // 默认值处理
        if (!StringUtils.hasText(userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty(userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }

        // 账户类型
        Set<SysUserTypeBO> typesAdd = new HashSet<>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue(), employeeId == null ? null : employeeId.toString()));
        userSaveBO.setUserTypesAdd(typesAdd);
        if (CollUtil.isNotEmpty(saveVO.getUserTypes())) {
            userSaveBO.setUserTypes(saveVO.getUserTypes().stream().map(t -> new SysUserTypeBO(t.getType(), t.getIdentityId())).collect(Collectors.toSet()));
        }

        return userSaveBO;
    }

    private SysUserSaveBO toUserSaveBO(EmployeeUpsertDTO upsertDTO) {
        Long userId = upsertDTO.getUserId();
        if (userId == null && StringUtils.hasText(upsertDTO.getUsername())) {
            userId = this.userRepoCall(proc -> proc.getIdByUsername(upsertDTO.getUsername()));
        }

        // 转为BO
        SysUserSaveBO userSaveBO = null;
        if (userId == null) {
            userSaveBO = CONVERT.upsertDTO2UserSaveBo(upsertDTO);
            if (CharSequenceUtil.isBlank(upsertDTO.getUsername()) && !ObjectUtil.defaultIfNull(upsertDTO.getWithoutLoginAccount(), false)) {
                // 生成随机账号
                String username = super.generateRandomCode(u -> !this.userRepoCall(proc -> proc.existsUsername(u)));
                userSaveBO.setUsername(username);
            }
        } else {
            Assert.hasText(upsertDTO.getUsername(), "登录号为空");
            // 先查询出原有信息
            Long finalUserId = userId;
            var userDO = this.userRepoCall(proc -> proc.get(finalUserId));
            Assert.notNull(userDO, "员工所属账号不存在");
            userSaveBO = CONVERT_USER.do2SaveBo(userDO);
            CONVERT.copyUpserDTO2UserSaveBO(upsertDTO, userSaveBO);
            userSaveBO.setId(userId);
            userSaveBO.setMobile(upsertDTO.getPhone());
        }

        // 地区
        userSaveBO.setAreaBO(CONVERT_AREA.vo2Bo(upsertDTO.getAreaVO()));

        // 默认值处理
        if (!StringUtils.hasText(userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty(userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }

        // 账号类型
        Set<SysUserTypeBO> typesAdd = new HashSet<>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue(), upsertDTO.getId() == null ? null : upsertDTO.getId().toString()));
        if (CollUtil.isNotEmpty(upsertDTO.getUserTypeList())) {
            for (SysUserTypeDTO sysUserTypeDTO : upsertDTO.getUserTypeList()) {
                typesAdd.add(new SysUserTypeBO(sysUserTypeDTO.getUserType(), sysUserTypeDTO.getIdentityId()));
            }
        }
        userSaveBO.setUserTypesAdd(typesAdd);

        return userSaveBO;
    }

    private SysUserSaveBO toUserSaveBO(ImportEmployeeBO employeeBO) {
        // 转为BO
        SysUserSaveBO userSaveBO = CONVERT.importBo2UserSaveBo(employeeBO);
        if (!employeeBO.getWithoutLoginAccount()) {
            boolean existsUsername = userRepoCall(userRepoProc -> userRepoProc.existsUsername(userSaveBO.getUsername()));
            Assert.isTrue(!existsUsername, "登录号已存在");
        }

        // 默认值处理
        if (!StringUtils.hasText(userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty(userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }
        Set<SysUserTypeBO> typesAdd = new HashSet<>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue()));
        userSaveBO.setUserTypesAdd(typesAdd);

        return userSaveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(EmployeeOrgInfoSaveVO saveVO, Long employeeId) {
        if (employeeId == null) {
            employeeId = saveVO.getId();
        }

        // 转为BO
        SysEmployeeSaveBO saveBO = null;
        if (employeeId == null) {
            saveBO = CONVERT.saveVO2BO(saveVO);
        } else {
            var employeeDO = employeeRepoProc.get(employeeId);
            Assert.notNull(employeeDO, "员工信息不存在");
            saveBO = CONVERT.do2SaveBO(employeeDO);
            CONVERT.copy2SaveBO(saveVO, saveBO);
            saveBO.setId(employeeId);
        }

        // 默认值处理
        List<SysEmployeeOrgSaveBO> orgInfos = new ArrayList<>(0);
        if (CollUtil.isNotEmpty(saveVO.getOrgList())) {
            orgInfos = saveVO.getOrgList().stream()
                    .filter(t -> t.getOrgId() != null)
                    .map(t -> {
                        SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                        orgInfo.setOrgId(t.getOrgId());
                        orgInfo.setLeaderUserId(t.getLeaderUserId());
                        orgInfo.setDef(t.getDef() != null && t.getDef());
                        orgInfo.setAssignee(t.getAssignee() != null && t.getAssignee());
                        orgInfo.setPositionId(t.getPositionId());
                        return orgInfo;
                    }).collect(Collectors.toList());
            var defSize = orgInfos.stream().filter(t -> Boolean.TRUE.equals(t.getDef())).count();
            Assert.isTrue(defSize < 2, "默认组织只能有一个");
        }
        Assert.notEmpty(orgInfos, "组织信息不能为空");
        saveBO.setOrgInfoList(orgInfos);
        saveBO.setEmailWork(saveVO.getEmailWork());
        saveBO.setPhone(saveVO.getPhoneWork());

        return saveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(EmployeeUpsertDTO upsertDTO) {
        // 判断员工是否已存在
        Long employeeId = upsertDTO.getId();
        if (employeeId == null && StringUtils.hasText(upsertDTO.getCode())) {
            employeeId = employeeRepoProc.getIdByCode(upsertDTO.getCode());
            upsertDTO.setId(employeeId);
        }

        // 转为BO
        SysEmployeeSaveBO saveBO = null;
        if (employeeId == null) {
            saveBO = CONVERT.saveDto2BO(upsertDTO);
            if (CharSequenceUtil.isBlank(saveBO.getCode())) {
                // 生成随机编号
                String code = super.generateRandomCode(t -> !employeeRepoProc.existsCode(t));
                saveBO.setCode(code);
            }
        } else {
            Assert.hasText(upsertDTO.getCode(), "员工编号为空");
            var employeeDO = employeeRepoProc.get(employeeId);
            Assert.notNull(employeeDO, "员工信息不存在");
            saveBO = CONVERT.do2SaveBO(employeeDO);
            CONVERT.copy2SaveBO(upsertDTO, saveBO);
            saveBO.setId(employeeId);
            upsertDTO.setUserId(employeeDO.getUserId());
        }

        // 组织处理
        List<SysEmployeeOrgSaveBO> orgInfos = new ArrayList<>(0);
        Set<Long> existsOrgIds = new HashSet<>();
        if (CollUtil.isNotEmpty(upsertDTO.getOrgList())) {
            for (EmployeeUpsertDTO.EmployeeOrg t : upsertDTO.getOrgList()) {
                if (t.getOrgId() == null || existsOrgIds.contains(t.getOrgId())) {
                    continue;
                }
                existsOrgIds.add(t.getOrgId());

                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t.getOrgId());
                orgInfo.setLeaderUserId(t.getLeaderUserId());
                orgInfo.setDef(ObjUtil.defaultIfNull(t.getDef(), false));
                orgInfo.setAssignee(ObjUtil.defaultIfNull(t.getAssignee(), false));
                orgInfo.setPositionId(t.getPositionId());
                orgInfos.add(orgInfo);
            }
        }
        if (CollUtil.isNotEmpty(upsertDTO.getOrgIdList())) {
            Map<Long, SysEmployeeOrgDO> empOrgOldMap = employeeId == null ? Collections.emptyMap() : employeeOrgRepoProc.getEmployeeOrgByEmployeeId(employeeId)
                    .stream().collect(Collectors.toMap(SysEmployeeOrgDO::getOrgId, Function.identity(), (t1, t2) -> t1));
            for (Long t : upsertDTO.getOrgIdList()) {
                if (t == null || existsOrgIds.contains(t)) {
                    continue;
                }
                existsOrgIds.add(t);

                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t);
                SysEmployeeOrgDO old = empOrgOldMap.get(t);
                if (old == null) {
                    orgInfo.setDef(false);
                    orgInfo.setAssignee(false);
                } else {
                    orgInfo.setDef(old.getDef());
                    orgInfo.setAssignee(old.getAssignee());
                }
                orgInfos.add(orgInfo);
            }
        }
        Assert.notEmpty(orgInfos, "组织信息不能为空");
        saveBO.setOrgInfoList(orgInfos);

        return saveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(ImportEmployeeBO employeeBO) {
        // 转为BO
        var saveBO = CONVERT.importBo2SaveBo(employeeBO);
        boolean existsCode = employeeRepoProc.existsCode(saveBO.getCode());
        Assert.isTrue(!existsCode, "员工编号已存在");

        // 默认值处理
        List<SysEmployeeOrgSaveBO> orgInfos = new ArrayList<>(0);
        if (CollUtil.isNotEmpty(employeeBO.getOrgIds())) {
            orgInfos = employeeBO.getOrgIds().stream()
                    .filter(Objects::nonNull)
                    .map(t -> {
                        SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                        orgInfo.setOrgId(t);
                        orgInfo.setDef(false);
                        orgInfo.setAssignee(false);

                        return orgInfo;
                    }).collect(Collectors.toList());
        }
        Assert.notEmpty(orgInfos, "组织信息为空");
        saveBO.setOrgInfoList(orgInfos);

        return saveBO;
    }

    private EmployeeOrgInfoRespVO getEmployeeOrgInfo(SysEmployeeDO employeeDO) {
        var respVO = CONVERT.do2RespVO(employeeDO);
        respVO.setEmailWork(employeeDO.getEmail());

        // 员工类型
        if (StringUtils.hasText(respVO.getType())) {
            var employeeTypeMap = super.udcMap(new EmployeeType());
            respVO.setTypeName(employeeTypeMap.get(respVO.getType()));
        }
        respVO.setExtensionInfo(employeeDO.getExtensionInfo());
        // 获取组织
        var orgList = getEmployeeOrgs(employeeDO.getId()).getData();
        respVO.setOrgList(orgList);

        return respVO;
    }

    private Map<Long, SysUserBasicDTO> queryUser(EmployeePageQueryVO queryVO) {
        UserQueryDTO queryDTO = new UserQueryDTO();
        boolean flag = false;

        if (StringUtils.hasText(queryVO.getUsername())) {
            queryDTO.setUsernames(Set.of(queryVO.getUsername()));
            flag = true;
        }

        if (!flag) {
            // 不根据用户查询
            return null;
        }

        var users = userRepoCall(repo -> repo.queryBasicDto(queryDTO));
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        return users
                .stream()
                .collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
    }
}
