package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.common.LoggingProperties;
import com.elitescloud.cloudt.system.common.TrackType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.service.InfinityLogListener;
import com.elitescloud.cloudt.system.service.InfinityTrackService;
import com.elitescloud.cloudt.system.service.PersistenceService;
import com.elitescloud.cloudt.system.util.HttpServletUtil;
import com.elitescloud.cloudt.system.util.ResponseWrapper;
import com.elitescloud.cloudt.system.util.TenantSpiUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:15
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityTrackServiceImpl implements InfinityTrackService {
    private final PersistenceService persistenceService;
    @Autowired(required = false)
    private InfinityLogListener infinityLogListener;

    /**
     * 接口(被动)调用日志
     */
    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper(response);
        Map<String, Object> param = new HashMap<>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, HttpServletUtil.wrapper(request),
                TrackType.LOG_INFINITY_PASSIVE.getCode(), "[INFINITY] 接口(被动)调用日志", param, "");
    }

    /**
     * 接口(主动)调用日志
     */
    @Override
    public void record(InfinityLogVO requestParam) {
        persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG,
                TrackType.LOG_INFINITY_INVOKE.getCode(), "[INFINITY" +
                        "] 接口(主动)调用日志",
                requestParam, null);
        if (infinityLogListener != null) {
            try {
                boolean result = infinityLogListener.createLog(requestParam);
                if (!result) {
                    log.error("[INFINITY] log listener record failed");
                }
            } catch (Exception e) {
                log.error("[INFINITY] log listener record error: ", e);
            }
        }
    }
}
