package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiRetryDO;
import com.elitescloud.cloudt.system.service.ThirdApiRetrySupportService;
import com.elitescloud.cloudt.system.service.repo.ThirdApiLogRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiRetryRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/14
 */
@Slf4j
@Service
@ConditionalOnClass(RetryTaskProvider.class)
class ThirdApiRetryTaskProvider implements RetryTaskProvider<ThirdApiRetry.RetryParam> {

    @Autowired
    private ThirdApiRetryRepoProc retryRepoProc;
    @Autowired
    private ThirdApiLogRepoProc repoProc;
    @Autowired()
    @Lazy
    private ThirdApiRetrySupportService supportService;

    @Override
    public List<ThirdApiRetry.RetryParam> queryTask(String lastTaskId, int size) {
        Long taskId = StringUtils.hasText(lastTaskId) ? Long.parseLong(lastTaskId) : null;
        var recordList = retryRepoProc.listToRetry(taskId, size);
        if (recordList.isEmpty()) {
            return Collections.emptyList();
        }

        var ids = recordList.stream().map(SysThirdApiRetryDO::getRecordLogId).collect(Collectors.toSet());
        var lastRetryIdMap = repoProc.queryLastRetry(ids);

        return recordList.stream().filter(t -> lastRetryIdMap.containsKey(t.getRecordLogId())).map(t -> {
            ThirdApiRetry.RetryParam param = new ThirdApiRetry.RetryParam();
            param.setTaskId(lastRetryIdMap.get(t.getRecordLogId()).toString());
            param.setVersion(t.getAuditDataVersion());
            param.setRetryTimes(t.getRetryTimes());
            param.setRetryTime(t.getSendTimeNext());

            return param;
        }).collect(Collectors.toList());
    }

    @Override
    public void deleteTask(@NotBlank String taskId, String reason) {
        if (CharSequenceUtil.isBlank(taskId)) {
            log.info("删除重试任务异常，任务ID为空");
            return;
        }

        supportService.deleteRetry(Long.parseLong(taskId), reason);
    }

    @Override
    public boolean trySend(@NotBlank String taskId, Integer version) {
        if (CharSequenceUtil.isBlank(taskId)) {
            log.info("判断是否可以发送异常，任务ID为空");
            return false;
        }

        return ObjectUtil.defaultIfNull(supportService.trySend(Long.parseLong(taskId), version).getData(), false);
    }

    @Override
    public void updateRetryResult(String taskId, boolean success, String failReason) {
        if (CharSequenceUtil.isBlank(taskId)) {
            log.info("修改重试结果异常，任务ID为空");
            return;
        }

        supportService.updateRetryResult(Long.parseLong(taskId), success, failReason);
    }
}
