package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/20
 */
@Repository
public class AdminMenuRepoProc extends BaseRepoProc<SysPlatformAdminMenusDO> {
    private static final QSysPlatformAdminMenusDO QDO = QSysPlatformAdminMenusDO.sysPlatformAdminMenusDO;
    private static final QSysPlatformMenusDO QDO_MENU = QSysPlatformMenusDO.sysPlatformMenusDO;

    public AdminMenuRepoProc() {
        super(QDO);
    }

    public List<String> getMenuCodes(Collection<String> adminTypes) {
        var predicate = PredicateBuilder.builder()
                .andIn(QDO.adminType, adminTypes)
                .build();
        return super.getValueList(QDO.menusCode, predicate);
    }
}
