package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Repository
public class ApiManageRepoProc extends BaseRepoProc<SysPlatformApiManageDO> {
    private static final QSysPlatformApiManageDO QDO = QSysPlatformApiManageDO.sysPlatformApiManageDO;

    public ApiManageRepoProc() {
        super(QDO);
    }

    /**
     * 根据编码获取ID
     *
     * @param apiCode 接口编码
     * @return 接口ID
     */
    public Long getIdByCode(@NotBlank String apiCode) {
        return super.getIdByValue(QDO.apiCode, apiCode);
    }

    /**
     * 获取接口编码
     *
     * @param id
     * @return
     */
    public String getCode(long id) {
        return super.getValue(QDO.apiCode, id);
    }

    /**
     * 根据编码获取应用编码
     *
     * @param apiCode 接口编码
     * @return 应用编码
     */
    public String getAppCodeByCode(@NotBlank String apiCode) {
        return super.getValueByValue(QDO.appCode, QDO.apiCode, apiCode);
    }
}
