package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysDataSelectorGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataSelectorGroupDO;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Repository
public class DataSelectorGroupRepoProc extends BaseRepoProc<SysDataSelectorGroupDO> {
    private static final QSysDataSelectorGroupDO QDO = QSysDataSelectorGroupDO.sysDataSelectorGroupDO;

    public DataSelectorGroupRepoProc() {
        super(QDO);
    }

    public boolean existsCode(@NotBlank String groupCode) {
        return super.exists(QDO.groupCode, groupCode);
    }

    public void updateEnabled(long id, boolean enabled) {
        super.updateValue(QDO.enabled, enabled, id);
    }

    public void updateEnabled(@NotBlank String groupCode, boolean enabled) {
        super.updateValueByValue(QDO.enabled, enabled, QDO.groupCode, groupCode);
    }

    public void updateGroupName(long id, String groupName) {
        super.updateValue(QDO.groupName, groupName, id);
    }

    public void updateGroupName(@NotBlank String groupCode, String groupName) {
        super.updateValueByValue(QDO.groupName, groupName, QDO.groupCode, groupCode);
    }

    public void deleteByGroupCode(@NotBlank String groupCode) {
        super.deleteByValue(QDO.groupCode, groupCode);
    }

    public String getNameByCode(@NotBlank String groupCode) {
        return super.getValueByValue(QDO.groupName, QDO.groupCode, groupCode);
    }

    public Map<String, String> getNamesByCode(@NotEmpty Collection<String> groupCodes) {
        return super.queryMap(QDO.groupCode, QDO.groupName);
    }

    public SysDataSelectorGroupDO getByGroupCode(@NotBlank String groupCode) {
        return super.getOneByValue(QDO.groupCode, groupCode);
    }

    public List<IdCodeNameParam> listGroup() {
        var qBean = Projections.bean(IdCodeNameParam.class, QDO.id, QDO.groupCode.as("code"), QDO.groupName.as("name"));
        return super.getList(qBean, QDO.enabled.eq(true), defaultOrder());
    }

    private OrderSpecifier<Integer> defaultOrder() {
        return QDO.sortNo.asc();
    }
}
