package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.service.model.entity.QSysNoticeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import com.querydsl.core.types.dsl.StringExpression;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.Collection;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Repository
public class NoticeRepoProc extends BaseRepoProc<SysNoticeDO> {

    private static final QSysNoticeDO QDO = QSysNoticeDO.sysNoticeDO;

    public NoticeRepoProc() {
        super(QDO);
    }

    public void updateTxtId(long id, long txtId) {
        super.updateValue(QDO.txtId, txtId, id);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePublish(@NotEmpty Collection<Long> ids, LocalDateTime publishTime) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, true)
                .set(QDO.publishTime, publishTime)
                .where(QDO.id.in(ids).and(QDO.published.eq(false)).and(QDO.publishTime.isNull()))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updatePublish(@NotEmpty Collection<Long> ids) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, true)
                .where(QDO.id.in(ids).and(QDO.published.eq(false)).and(QDO.publishTime.isNotNull()))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateRevoke(@NotEmpty Collection<Long> ids) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.published, false)
                .setNull(QDO.publishTime)
                .where(QDO.id.in(ids).and(QDO.published.eq(true)))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void increaseNum(long id) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.readAmount, QDO.readAmount.add(1))
                .where(QDO.id.eq(id))
                .execute();
    }

    public PagingVO<SysNoticeDO> pageMng(NoticePageMngQueryVO queryVO, boolean sys) {
        var predate = PredicateBuilder.builder()
                .andEq(QDO.authorId, queryVO.getAuthorId())
                .andLike(QDO.title, queryVO.getTitle())
                .andEq(QDO.category, queryVO.getCategory())
                .andEq(QDO.noticeType, queryVO.getNoticeType())
                .andEq(QDO.top, queryVO.getTop())
                .andEq(QDO.published, queryVO.getPublished())
                .andEq(QDO.sys, sys)
                .andBetween(QDO.publishTime, queryVO.getPublishTimeStart(), queryVO.getPublishTimeEnd())
                .andLike(new StringExpression[]{QDO.title, QDO.summaries}, queryVO.getKeyword())
                .build();
        return super.queryByPage(predate, queryVO.getPageRequest(), QDO.createTime.desc());
    }

    public PagingVO<SysNoticeDO> pagePublished(CommonPublishedNoticePageQueryVO queryVO) {
        var predate = PredicateBuilder.builder()
                .andEq(QDO.category, queryVO.getCategory())
                .andEq(QDO.noticeType, queryVO.getNoticeType())
                .andLoe(QDO.publishTime, LocalDateTime.now())
                .andEq(QDO.published, true)
                .andEq(QDO.sys, queryVO.getSys())
                .andLike(QDO.title, queryVO.getTitle())
                .andLike(new StringExpression[]{QDO.title, QDO.summaries}, queryVO.getKeyword())
                .build();

        var pageRequest = queryVO.getPageRequest();

        pageRequest = pageRequest.withSort(Sort.Direction.DESC, QDO.top.getMetadata().getName(), QDO.publishTime.getMetadata().getName());
        return super.queryByPage(predate, pageRequest);
    }
}
