package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleRelatedDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleRelatedDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/6 周日
 */
@Repository
public class RoleRelatedRepoProc extends BaseRepoProc<SysRoleRelatedDO> {
    private static final QSysRoleRelatedDO QDO = QSysRoleRelatedDO.sysRoleRelatedDO;

    public RoleRelatedRepoProc() {
        super(QDO);
    }

    /**
     * 根据关联对象删除
     *
     * @param relatedId
     * @param relatedType
     */
    public void deletedByRelated(@NotBlank String relatedId, @NotBlank String relatedType) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.relatedId.eq(relatedId))
                .and(QDO.relatedType.eq(relatedType))
                .build();
        super.delete(predicate);
    }

    /**
     * 根据角色(组)编码删除
     *
     * @param roleCode
     * @param isGroup
     */
    public void deletedByRoleCode(@NotBlank String roleCode, boolean isGroup) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.roleCode.eq(roleCode))
                .and(QDO.roleGroup.eq(isGroup))
                .build();
        super.delete(predicate);
    }

    /**
     * 根据角色(组)编码查询
     *
     * @param roleCode
     * @param isGroup
     * @return
     */
    public List<SysRoleRelatedDO> queryByRoleCode(@NotBlank String roleCode, boolean isGroup) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.roleCode.eq(roleCode))
                .and(QDO.roleGroup.eq(isGroup))
                .build();
        return super.getList(predicate);
    }

    /**
     * 根据关联类型和关联标识查询角色关联关系
     **/
    public List<SysRoleRelatedDO> queryByRelated(@NotBlank String relatedId, @NotBlank String relatedType) {
        var predicate = PredicateBuilder.builder()
                .and(QDO.relatedType.eq(relatedType))
                .and(QDO.relatedId.eq(relatedId))
                .build();
        return super.getList(predicate);
    }
}
