package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.provider.usersync.SyncUserResult;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserSyncRecordDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserSyncRecordDO;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Repository
public class UserSyncRecordRepoProc extends BaseRepoProc<SysUserSyncRecordDO> {
    private static final QSysUserSyncRecordDO QDO = QSysUserSyncRecordDO.sysUserSyncRecordDO;

    public UserSyncRecordRepoProc() {
        super(QDO);
    }

    /**
     * 更新同步结果
     *
     * @param id
     * @param syncResult
     * @param failReasonDetail
     */
    public void updateSyncResult(long id, SyncUserResult syncResult, String failReasonDetail) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.syncSuccess, syncResult.isSuccess())
                .set(QDO.syncFinishTime, LocalDateTime.now())
                .set(QDO.failReason, syncResult.getFailMsg())
                .set(QDO.failReasonDetail, failReasonDetail)
                .set(QDO.receipt, syncResult.getReceipt())
                .set(QDO.outerUserId, syncResult.getOuterUserId())
                .set(QDO.outerUserCode, syncResult.getOuterUserCode())
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 获取列表记录
     *
     * @param outerSysCode
     * @param userId
     * @return
     */
    public List<SysUserSyncRecordDO> listSyncRecord(String outerSysCode, Long userId) {
        return super.getList(QDO.userId.eq(userId).and(QDO.outerSysCode.eq(outerSysCode)));
    }
}
