package com.elitescloud.cloudt.system.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.date.format.FastDateFormat;

import java.util.Date;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:28
 * @Description:
 */
public class DateUtils extends DateTime {

    /**
     * 点符号分隔符的日期格式：yyyy.MM.dd
     */
    public static final String DOT_DATE_PATTERN = "yyyy.MM.dd";

    /**
     * 点符号分隔符的日期格式 {@link FastDateFormat}：yyyy.MM.dd
     */
    public static final FastDateFormat DOT_DATE_FORMAT = FastDateFormat.getInstance(DOT_DATE_PATTERN);

    /**
     * 当前日期，格式 yyyy.MM.dd
     *
     * @return 当前日期的标准形式字符串
     */
    public static String todayDot() {
        return DOT_DATE_FORMAT.format(new Date());
    }

    /**
     * 现在的时间
     *
     * @return 格式字符串 yyyy-MM-dd HH:mm:ss
     */
    public static String nowStr() {
        return DateTime.now().toString();
    }

    /**
     * 根据特定格式格式化日期
     *
     * @param dateCharSequence 日期字符串
     * @param format           日期格式，常用格式见： {@link DatePattern} {@link DatePattern#NORM_DATETIME_PATTERN}
     * @return 格式化后的字符串
     * @since 0.1.13-SNAPSHOT
     */
    public static String format(CharSequence dateCharSequence, String format) {
        DateTime dateTime = DateUtil.parse(dateCharSequence);
        return DateUtil.format(dateTime, format);
    }

    /**
     * 根据特定格式格式化日期
     *
     * @param dateCharSequence 日期字符串
     * @param format           {@link DatePrinter} 或 {@link FastDateFormat} {@link DatePattern#NORM_DATETIME_FORMAT}
     * @return 格式化后的字符串
     * @since 0.1.13-SNAPSHOT
     */
    public static String format(CharSequence dateCharSequence, DatePrinter format) {
        DateTime dateTime = DateUtil.parse(dateCharSequence);
        return DateUtil.format(dateTime, format);
    }
}
