/*
 * Copyright © 2017-2018 All Rights Reserved
 *  上海仰空网络科技有限公司 版权所有
 *
 */

package com.elitescloud.cloudt.system.util;


import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 * @author Samson
 */
public class EncodeUtils {

  private static final String DEFAULT_URL_ENCODING = "UTF-8";
  private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
      .toCharArray();

  public static String encodeHex(byte[] input) {
    return Hex.encodeHexString(input);
  }

  public static byte[] decodeHex(String input) {
    try {
      return Hex.decodeHex(input.toCharArray());
    } catch (DecoderException e) {
      throw new RuntimeException(e);
    }
  }

  public static String encodeBase64(byte[] input) {
    return Base64.encodeBase64String(input);
  }

  public static String encodeUrlSafeBase64(byte[] input) {
    return Base64.encodeBase64URLSafeString(input);
  }

  public static byte[] decodeBase64(String input) {
    return Base64.decodeBase64(input);
  }

  public static String encodeBase62(byte[] input) {
    char[] chars = new char[input.length];
    for (int i = 0; i < input.length; i++) {
      chars[i] = BASE62[((input[i] & 0xFF) % BASE62.length)];
    }
    return new String(chars);
  }

  public static String escapeHtml(String html) {
    return StringEscapeUtils.escapeHtml4(html);
  }

  public static String unescapeHtml(String htmlEscaped) {
    return StringEscapeUtils.unescapeHtml4(htmlEscaped);
  }

  public static String escapeXml(String xml) {
    return StringEscapeUtils.escapeXml(xml);
  }

  public static String unescapeXml(String xmlEscaped) {
    return StringEscapeUtils.unescapeXml(xmlEscaped);
  }

  public static String urlEncode(String part) {
    try {
      return URLEncoder.encode(part, "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }

  public static String urlDecode(String part) {
    try {
      return URLDecoder.decode(part, "UTF-8");
    } catch (UnsupportedEncodingException e) {
      throw new RuntimeException(e);
    }
  }
}
