package com.elitescloud.cloudt.system.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;

import java.util.concurrent.atomic.AtomicReference;

/**
 * @Auther: Mark
 * @Date: 2024/12/25 19:54
 * @Description:
 */
public class ThirdSysLogUtil {
    public static final String APP_CODE = "YST-SYS";

    private static SysThirdApiLogRpcService sysThirdApiLogRpcService;


    public static Long logUpload(String businessType, String businessKey, UploadResult uploadResult,
                                 ThirdApiRetryParamDTO retryParamDTO, Boolean needRetry) {
        ThirdApiLogDTO thirdApiLogDTO = new ThirdApiLogDTO();
        thirdApiLogDTO.setAppCode(APP_CODE);
        thirdApiLogDTO.setBusinessType(businessType);
        thirdApiLogDTO.setBusinessKey(businessKey);
        thirdApiLogDTO.setThirdApp(uploadResult.getThirdApp());
        thirdApiLogDTO.setReqBody(uploadResult.getRequest());
        thirdApiLogDTO.setRespBody(uploadResult.getResp());
        thirdApiLogDTO.setReqHeaders(uploadResult.getReqHeaders());
        thirdApiLogDTO.setReqQueryParams(uploadResult.getReqQueryParams());
        thirdApiLogDTO.setReqMethod(uploadResult.getReqMethod());
        thirdApiLogDTO.setServer(false);
        thirdApiLogDTO.setReqTime(uploadResult.getReqTime());
        thirdApiLogDTO.setUri(uploadResult.getUri());
        thirdApiLogDTO.setServerAddr(uploadResult.getServerAddr());
        thirdApiLogDTO.setRestful(uploadResult.getRestful());
        thirdApiLogDTO.setReqSuccess(uploadResult.getReqSuccess());
        thirdApiLogDTO.setReqFailMsg(uploadResult.getReqFailMsg());
        thirdApiLogDTO.setRespSuccess(uploadResult.getSuccess());
        thirdApiLogDTO.setNeedRetry(false);


        if (sysThirdApiLogRpcService == null) {
            sysThirdApiLogRpcService = SpringUtil.getBean(SysThirdApiLogRpcService.class);
        }
        AtomicReference<Long> logId = new AtomicReference<>(0L);
        TransactionUtil.runNewTx(() -> {
            ApiResult<Long> longApiResult = sysThirdApiLogRpcService.saveLog(thirdApiLogDTO);
            logId.set(longApiResult.computeData());
        });
        return logId.get();
    }
}
